<?php

add_action('cmb2_init', 'alt_metabox_banners');


/**
 * Define the metabox and field configurations.
 */
function alt_metabox_banners()
{


    // Start with an underscore to hide fields from custom fields list
    $prefix = 'alt_';

    /**
     * Initiate the metabox
     */
    $cmb = new_cmb2_box(array(
        'id' => 'field_filial_banners',
        'title' => 'Configuração',
        'object_types' => array('banners'), // Post type
        'context' => 'normal',
        'priority' => 'high',
        'show_names' => true,
        'show_in_rest' => false,
    ));

    $cmb->add_field(array(
            'name' => 'Link',
            'desc' => 'Informe o link que deverá ser aberto',
            'id' => $prefix . 'banner_link',
            'type' => 'text_url',
            'protocols' => array('http', 'https'),

        )
    );
    $cmb->add_field(array(
            'name' => 'Abrir em nova guia',
            'desc' => '',
            'id' => $prefix . 'banner_nova_guia',
            'type' => 'select',
            'show_option_none' => false,
            'default'          => 'nao',
            'options'          => array(
                'nao' => 'Não',
                'sim'   => 'Sim',
            ),
        )
    );

    $cmb->add_field(array(
            'name' => 'Exibir texto',
            'desc' => 'O texto será exibido na frente do banner',
            'id' => $prefix . 'banner_exibir_texto',
            'type' => 'select',
            'show_option_none' => false,
            'default'          => 'sim',
            'options'          => array(
                'nao' => 'Não',
                'sim'   => 'Sim',
            ),
        )
    );


    $cmb->add_field(array(
            'name' => 'Url Vídeo',
            'desc' => 'Informe a URL do vídeo',
            'id' => $prefix . 'banner_video',
            'type' => 'text_url',
            'protocols' => array('http', 'https'),

        )
    );

    $cmb->add_field(array(
        'name' => 'Selecione a imagem',
        'desc' => 'Selecione o arquivo ou informe a URL.',
        'id' => $prefix . 'banner_imagem',
        'type' => 'file',
        // Optional:
        'options' => array(
            'url' => true, // Hide the text input for the url
        ),
        'text' => array(
            'add_upload_file_text' => 'Adicionar arquivo' // Change upload button text. Default: "Add or Upload File"
        ),
        // query_args are passed to wp.media's library query.
        'query_args' => array(
            //'type' => 'application/pdf', // Make library only display PDFs.
            // Or only allow gif, jpg, or png images
            'type' => array(
                'image/gif',
                'image/jpeg',
                'image/png',
            ),
        ),
        'preview_size' => 'alt-banners', // Image size to use when previewing in the admin.
    ));


}

