<?php
include 'exclusao_fotos.php';

add_action('wp', 'activateME');

function activateME()
{

    $snNoticia = get_importar_noticias();


    if ($snNoticia) {
        if (!wp_next_scheduled('alt_cron_noticias')) {
            wp_schedule_event(current_time('timestamp'), 'twicedaily', 'alt_cron_noticias');
        }
    } else {
        wp_clear_scheduled_hook('alt_cron_noticias');
    }


}
add_action('alt_cron_noticias', 'alt_importar_noticias_cron');
//do_action('alt_cron_noticias'); //ativar o cron para debug
function alt_importar_noticias_cron()
{

    require_once(ABSPATH . "wp-includes/pluggable.php");


    $arrNoticias = importar_noticias_curl();


    $user_id = get_current_user_id();

    foreach ($arrNoticias as $noticia) {


        //VERIFICAR SE NOTICIA JÁ EXISTE
        $the_slug = $noticia['slug'];
        $args = array(
            'name' => $the_slug,
            'post_type' => 'post'
        );
        $my_posts = get_posts($args);
        if ($my_posts) {
            continue;
        }


        $pid = 168; // post we will set it's categories
        $cat_name = 'Notícias'; // category name we want to assign the post to
        $taxonomy = 'category'; // category by default for posts for other custom post types like woo-commerce it is product_cat
        $append = true;// true means it will add the cateogry beside already set categories. false will overwrite
        $cat = get_term_by('name', $cat_name, $taxonomy);
        if ($cat == false) {
            $cat = wp_insert_term($cat_name, $taxonomy);
            $cat_id = $cat['term_id'];
        } else {
            $cat_id = $cat->term_id;
        }

        $res = wp_set_post_terms($pid, array($cat_id), $taxonomy, $append);


        $my_post = array(
            'post_title' => $noticia['title'],
            'post_content' => html_entity_decode(json_decode($noticia['conteudo'])),
            'post_status' => 'publish',
            'post_name' => $the_slug,
            'post_author' => 1,
            'post_category' => $res,
            'post_date' => date('Y-m-d')//$noticia['data']

        );


        $post_id = wp_insert_post( $my_post);


        $url_imagem = $noticia['imagem'];
        $data_url = parse_url($url_imagem);
        $arrNameUrl = explode('/', $data_url['path']);
        $name_file = array_pop($arrNameUrl);
        $file = wp_upload_bits(sanitize_file_name($name_file), null, file_get_contents($url_imagem));

        $attachment = array(
            'guid' => $file['url'],
            'post_mime_type' => $file['type'],
            'post_title' => sanitize_file_name($name_file),
            'post_content' => '',
            'post_status' => 'inherit'
        );



        $attach_id = wp_insert_attachment($attachment, $file['file'], $post_id);

        require_once(ABSPATH . 'wp-admin/includes/image.php');

        $attach_data = wp_generate_attachment_metadata($attach_id, $file['file']);
        wp_update_attachment_metadata($attach_id, $attach_data);
        set_post_thumbnail($post_id, $attach_id);



    }


}
function importar_noticias_curl()
{

    $url = 'http://cms-site.altimus.com.br/conteudos/show.json';

    include_once(ABSPATH . WPINC . '/class-http.php');

    $request = new WP_Http;
    $data = $request->get($url);
    $conteudo = json_decode($data['body'], true);


    return $conteudo['conteudo'];
}

