<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly
}
/*
  Name: Altimus
  Plugin Name: Altimus
  Plugin URI: http://manutencaosites.windi.com.br/plugin/plugin.json
  Description: Plugin de integração com o sistema Altimus
  Author: Felipe Oliveira
  Version: 2020100
  Author URI: http://www.altimus.com.br/
  Text Domain: altimus
 */
define('MY_PLUGIN_PATH', plugin_dir_path(__FILE__));



//Customização
require_once 'inc/setup.php';

//Importar dados iniciais
require_once 'inc/import/ImportarXml.php';

require_once 'inc/seguranca.php';

require_once 'inc/api.php';


require_once 'inc/submit.php';

//Alteraçãos no woocommercea
require_once 'inc/woocommerce.php';
require_once 'inc/sidebar.php';
require_once 'inc/cronjobs.php';
require_once 'inc/shortcodes.php';
//TYPE POSTS
require_once 'inc/custom-post/depoimentos.php';
require_once 'inc/custom-post/banners.php';
require_once 'inc/custom-post/filiais.php';
require_once 'inc/custom-post/galeria.php';
require_once 'inc/custom-post/time.php';
/**
 * Ativar cronjob de importação de conteúdo
 */
require_once 'inc/import_blog.php';


require_once 'inc/tgm.php';

register_activation_hook(__FILE__, 'ativar_importacao_blog');


add_action('admin_menu', 'remove_menu_custom');


function remove_menu_custom()
{
    //remove_menu_page('edit-comments.php');
    //remove_menu_page('edit.php?post_type=page');
    //remove_menu_page('edit.php');
    //remove_menu_page('upload.php');

}


add_filter('sidebar_widget_footer', 'footer_widgets');

/* Register our callback function */
function footer_widgets($params)
{

    return $params;
}



/**
 * VERIFICAR SE PRECISA DE ATUALIZAÇÃO
 */
require 'plugin-update-checker/plugin-update-checker.php';


$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
    'http://manutencaosites.windi.com.br/plugin/plugin.json',
    __FILE__, //Full path to the main plugin file or functions.php.
    'altimus'
);


/**
 * DISABILITAR O GUTTEMBERBE
 */

if (!function_exists('alt_disable_gutenberg')) {
    function alt_disable_gutenberg()
    {

        global $wp_filter;

        $callbacks_array = $wp_filter['init']->callbacks;

        foreach ($wp_filter as $tag => $priorities) {
            foreach ($priorities->callbacks as $priority => $callback_data) {
                foreach ($callback_data as $callback_function_name => $callback_function_data) {

                    if (strpos($callback_function_name, 'disable_gutenberg') !== false) {
                        continue;
                    }

                    // Gutenberg disabler
                    if (strpos($callback_function_name, 'gutenberg') !== false || strpos($callback_function_name, 'block_editor')) {

                        remove_filter($tag, $callback_function_name, $priority);

                    }

                }
            }
        }

        $wp_filter['init']->callbacks = $callbacks_array;

        add_filter('use_block_editor_for_post_type', '__return_false');
    }
}
add_action('admin_init', 'alt_disable_gutenberg');


add_action('admin_bar_menu', 'toolbar_link_to_mypage', 999);
function toolbar_link_to_mypage($wp_admin_bar)
{


    $args0 = array(
        'id' => 'alt_menu_altimus',     // id of the existing child node (New > Post)
        'title' => 'Configurações Altimus', // alter the title of existing node
        'parent' => false,          // set parent to false to make it a top level (parent) node
    );

    $args1 = array(
        'id' => 'alt_setup',     // id of the existing child node (New > Post)
        'title' => 'Configurações gerais', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_setup',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args2 = array(
        'id' => 'alt_cores',     // id of the existing child node (New > Post)
        'title' => 'Configurações de cores', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_cores',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args3 = array(
        'id' => 'alt_header',     // id of the existing child node (New > Post)
        'title' => 'Configurações Header', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_contato_header',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args4 = array(
        'id' => 'alt_midias',     // id of the existing child node (New > Post)
        'title' => 'Configurações Mídias sociais', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_midias_sociais',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args5 = array(
        'id' => 'alt_listagem',     // id of the existing child node (New > Post)
        'title' => 'Configurações listagem (Estoque)', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_listagem',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $args6 = array(
        'id' => 'alt_detalhes',     // id ofaltimus/woocommerce/inc/functions.php the existing child node (New > Post)
        'title' => 'Configurações detalhes do veículo', // alter the title of existing node
        'href' => '/wp-admin/admin.php?page=alt_group_setup_detalhes',
        'parent' => 'alt_menu_altimus',          // set parent to false to make it a top level (parent) node
    );

    $wp_admin_bar->add_node($args0);
    $wp_admin_bar->add_node($args1);
    $wp_admin_bar->add_node($args2);
    $wp_admin_bar->add_node($args3);
    $wp_admin_bar->add_node($args4);
    $wp_admin_bar->add_node($args5);
    $wp_admin_bar->add_node($args6);
}


//Removes the meta tag generator name and version that generated with the wp_head()function.
remove_action('wp_head', 'wp_generator');


add_filter('wpcf7_spam', '__return_false');
